// DeleteMasterHoliday.cpp : implementation file
//

#include "stdafx.h"
#include "DB_APIVCClient.h"
#include "DeleteMasterHoliday.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


/////////////////////////////////////////////////////////////////////////////
// CDeleteMasterHoliday dialog


CDeleteMasterHoliday::CDeleteMasterHoliday(CWnd* pParent /*=NULL*/)
	: CDialog(CDeleteMasterHoliday::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDeleteMasterHoliday)
		// NOTE: the ClassWizard will add member initialization here
	m_bMaster = TRUE;
	//}}AFX_DATA_INIT
}

CDeleteMasterHoliday ::CDeleteMasterHoliday(IApplication *pApp, BOOL bMaster):CDialog(CDeleteMasterHoliday::IDD, NULL)
{
	pApplication = pApp;
	m_bMaster = bMaster;
	pMasterHol.CreateInstance(__uuidof(MasterHoliday));
	
}

void CDeleteMasterHoliday::LoadMasterHolidays()
{
	_variant_t vMasterHols;
	vMasterHols.Clear();
	_variant_t vHolGrps;
	vHolGrps.Clear();
	if(m_bMaster)
	{
		// Do Nothing
		pApplication->GetHolidayGroupsByAcctID(0,&vHolGrps);
	}
	else
	{
		int index = m_AcctList.GetCurSel();
		
		CString sAcctID;
		m_AcctList.GetLBText(index,sAcctID);
		long lAcctID = _wtoi(sAcctID);
		pApplication->GetHolidayGroupsByAcctID(lAcctID,&vHolGrps);
	}

	if(vHolGrps.vt == VT_EMPTY)
	{
			AfxMessageBox(L"No Holiday groups");
			return;
	}	
	long uBound =0 ;
	IHolidayGroup *pHolGrp =NULL;
	COleSafeArray sa(vHolGrps);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	for(long i =0 ;i <= uBound ; i++)
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IHolidayGroup,(void**)&pHolGrp);
		if (pHolGrp != NULL)
		{
			_variant_t vHolidays;
			vHolidays.Clear();
			pApplication->GetHolidaysByHolidayGroupID(pHolGrp->HolGrpID,&vHolidays);
			if(vHolidays.vt == VT_EMPTY || vHolidays.vt == VT_NULL)
			{
				continue;
			}
			long uBound =0 ;
			IMasterHoliday *pHol =NULL;
			COleSafeArray saHolidays;
			saHolidays = COleSafeArray(vHolidays);
			saHolidays.GetUBound(1,&uBound);
			UpdateData(TRUE);
			//BSTR bstrPanel;
			for(long i =0 ;i <= uBound ; i++)
			{
				IDispatch *pDisp = NULL;
				saHolidays.GetElement(&i,(void*)&pDisp);
				HRESULT hr = pDisp->QueryInterface(IID_IMasterHoliday,(void**)&pHol);
				if (pHol != NULL)
				{	
					CString sMasterHolID;
					sMasterHolID.Format(L"%ld",pHol->MasterHolidayID);
					m_MasterHolList.AddString(sMasterHolID);
					pHol->Release();
				}
				pDisp->Release();
			}	
		}
		pDisp->Release();
	}
	
	UpdateData(FALSE);
}
void CDeleteMasterHoliday::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDeleteMasterHoliday)
	DDX_Control(pDX, IDC_CMB_ACCT2, m_AcctList);
	DDX_Control(pDX, IDC_COMBO_MASTERHOLIDAYLIST, m_MasterHolList);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDeleteMasterHoliday, CDialog)
	//{{AFX_MSG_MAP(CDeleteMasterHoliday)
	ON_BN_CLICKED(IDC_DELETE, OnDelete)
	ON_CBN_SELCHANGE(IDC_CMB_ACCT2, OnSelchangeCmbAcct2)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDeleteMasterHoliday message handlers

BOOL CDeleteMasterHoliday::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	LoadAccounts();
	
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDeleteMasterHoliday::OnDelete() 
{
	int index = m_MasterHolList.GetCurSel();
	CString sHolName;
	m_MasterHolList.GetLBText(index,sHolName);
	long lMasterHolidayID = _wtoi(sHolName);
	long lStatus;
	if(m_bMaster)
	{
		// Do Nothing
	}
	else
		pApplication->DeleteHoliday(lMasterHolidayID, &lStatus);

	if (lStatus == 706)
	{
		AfxMessageBox(L"Given master holiday does not exist");
		return;
	}
	if (lStatus == 1)
	{
		AfxMessageBox(L"Holiday deletion Failed");
		return;
	}

	else
	{
		AfxMessageBox(L"Holiday deletion succeeded");
		CDialog::OnOK();
	}
}

void CDeleteMasterHoliday::LoadAccounts()
{
	_variant_t vAccounts;
	vAccounts.Clear();
	pApplication->GetAccounts(&vAccounts); // get account details in WP-CS database server
	
	if(vAccounts.vt ==  VT_EMPTY)
	{
		return;
	}
	
	long uBound =0 ;
	IAccount *pAccount = NULL;
	
	COleSafeArray sa(vAccounts);
	sa.GetUBound(1,&uBound);
	UpdateData(TRUE);
	for(long i =0 ;i <= uBound ; i++)
		
	{
		IDispatch *pDisp = NULL;
		sa.GetElement(&i,(void*)&pDisp);
		HRESULT hr = pDisp->QueryInterface(IID_IAccount,(void**)&pAccount);
		if (pAccount != NULL)
		{
			CString sAcctID;
			sAcctID.Format(L"%ld",pAccount->AccountID); 
			m_AcctList.AddString(sAcctID);
			pAccount->Release();
		}
		pDisp->Release();
	}
	UpdateData(FALSE);
}

void CDeleteMasterHoliday::OnSelchangeCmbAcct2() 
{
	m_MasterHolList.ResetContent();
	LoadMasterHolidays();	
}
